---
title: AI security · Cloudflare One docs
description: The AI security report dashboard summarizes your organization's AI
  usage and potential security risks.
lastUpdated: 2025-10-29T15:12:38.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/analytics/ai-security/
  md: https://developers.cloudflare.com/cloudflare-one/insights/analytics/ai-security/index.md
---

The AI security report dashboard summarizes your organization's AI usage and potential security risks.

To view the AI security report dashboard:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Insights**.
2. Go to **Dashboards**.
3. Select **AI security report**.

## Prerequisites

To populate the AI security report dashboard, you must have:

* [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) enabled to inspect outbound HTTP and DNS traffic.
* User traffic to SaaS AI applications (for example, ChatGPT or Gemini) sent through Cloudflare Gateway.
* MCP servers behind Cloudflare Access policies.

## Available insights

The AI security report dashboard includes the following panels and metrics:

* [Top 5 visited AI applications by user count](#top-5-visited-ai-applications-by-user-count)
* [Statuses applied to AI applications by application count](#statuses-applied-to-ai-applications-by-application-count)
* [Data uploaded to Artificial Intelligence applications by status](#data-uploaded-to-artificial-intelligence-applications-by-status)
* [MCP servers behind Access over time](#mcp-servers-behind-access-over-time)
* [Access login events to MCP servers](#access-login-events-to-mcp-servers)

### Top 5 visited AI applications by user count

Displays the most accessed AI tools in your organization and the number of users visiting each application in a time-series graph.\
Each bar represents user activity for a specific AI application (for example, ChatGPT or Gemini) over time.

Use this chart to monitor adoption trends and detect new or unauthorized AI tools being accessed.

### Statuses applied to AI applications by application count

Reports the total number of AI applications identified and their review statuses.\
Statuses include:

* Unreviewed — Applications not yet evaluated by administrators.
* In Review — Applications currently under review for approval.
* Unapproved — Applications that are restricted or blocked.
* Approved — Applications explicitly permitted for organizational use.

### Data uploaded to Artificial Intelligence applications by status

Reports the amount of data transferred to AI tools, broken down by review status (Unreviewed, In Review, Unapproved, Approved).\
Use this report to understand whether sensitive data is being sent to unapproved or unreviewed AI applications.

### MCP servers behind Access over time

Displays the number of Managed Control Plane (MCP) servers that are protected behind Access policies over time.\
Use this panel to monitor the number of MCP servers protected behind Access policies.

### Access login events to MCP servers

Reports the number of login events to MCP servers protected behind Access policies.\
Use this panel to monitor the number of login events to MCP servers protected behind Access policies.
