---
title: Cloudflare DNS · Cloudflare DNS docs
description: Cloudflare DNS is a fast, resilient and easy-to-manage
  authoritative DNS service. It delivers excellent performance and reliability
  to your domain while also protecting your business from DDoS attacks and route
  leaks and hijacking. To know where to begin, refer to Get started.
lastUpdated: 2025-06-06T12:18:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/
  md: https://developers.cloudflare.com/dns/index.md
---

Leverage Cloudflare's global network to deliver excellent performance and reliability to your domain.

Available on all plans

Cloudflare DNS is a fast, resilient and easy-to-manage authoritative DNS service. It delivers excellent performance and reliability to your domain while also protecting your business from [DDoS attacks](https://www.cloudflare.com/learning/ddos/what-is-a-ddos-attack/) and [route leaks and hijacking](https://www.cloudflare.com/learning/security/glossary/bgp-hijacking/). To know where to begin, refer to [Get started](https://developers.cloudflare.com/dns/get-started/).

Enterprise customers can also use Cloudflare DNS for their private network with [Internal DNS (Beta)](https://developers.cloudflare.com/dns/internal-dns/).

***

## Features

### DNS records

DNS records make resources available on your domain, and allow you to configure services such as email.

[Use DNS records](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/)

### DNSSEC

DNS Security Extensions (DNSSEC) adds cryptographic signatures to your DNS records, preventing anyone else from redirecting traffic intended for your domain.

Cloudflare also supports [Multi-signer DNSSEC](https://developers.cloudflare.com/dns/dnssec/multi-signer-dnssec/).

[Use DNSSEC](https://developers.cloudflare.com/dns/dnssec/)

### CNAME flattening

CNAME flattening delivers better performance and allows you to add a CNAME record at your apex domain (`example.com`). Paid accounts can choose to flatten all CNAME records on their domain.

[Use CNAME flattening](https://developers.cloudflare.com/dns/cname-flattening/)



Refer to [DNS features and availability](https://developers.cloudflare.com/dns/reference/all-features/) for a complete list of features and their availability according to different Cloudflare plans.

***

## Related products

**[Registrar](https://developers.cloudflare.com/registrar/)**

Before you can start using Cloudflare DNS you must first have a domain. Buy and renew your domain at cost with Cloudflare Registrar.

**[DNS Resolver](https://developers.cloudflare.com/1.1.1.1/)**

Cloudflare DNS focuses on businesses and their domain administration. If you are a consumer and want a more private way to browse the Internet, check out 1.1.1.1, Cloudflare's public DNS Resolver.
