---
title: Public buckets · Cloudflare Learning Paths
description: >
  This video outlines how to configure public buckets in R2, which are private
  by default, to enable public Internet access. It presents two methods for
  setting up public access: using a custom domain for greater control over
  content management and security, or using a Cloudflare-managed subdomain for a
  simpler configuration.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-2/
  md: https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-2/index.md
---

* Watch this episode

  This video outlines how to configure public buckets in R2, which are private by default, to enable public Internet access. It presents two methods for setting up public access: using a custom domain for greater control over content management and security, or a Cloudflare managed subdomain for a simpler configuration.

  **Related content**

  If you want to dive into detail, refer to the following pages:

  * [Public buckets](https://developers.cloudflare.com/r2/buckets/public-buckets/)
  * [Custom domains](https://developers.cloudflare.com/r2/buckets/public-buckets/#connect-a-bucket-to-a-custom-domain)

* Series overview

  [Watch Episode 1: Getting started with R2 ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-1/)In this video, you'll learn how to use Cloudflare R2 to store and manage data with no egress fees, supporting use cases like media, web assets, backups, and static site hosting.

  [Watch Episode 2: Public buckets ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-2/)This video outlines how to configure public buckets in R2, which are private by default, to enable public Internet access. It presents two methods for setting up public access: using a custom domain or a Cloudflare managed subdomain.

  [Watch Episode 3: S3 API compatibility ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-3/)In this video, you'll learn how to use S3 API commands and tools with R2, set up and configure R2 for S3 API compatibility, and integrate R2 into your existing workflows with minimal changes.

  [Watch Episode 4: Migrating your bucket data ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-4/)In this video, you will learn how to use Cloudflare R2's data migration tools to transfer data from other cloud providers such as Amazon S3 and Google Cloud Storage to R2.

  [Watch Episode 5: Accessing your bucket from Cloudflare Workers ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-5/)In this video, you will build a serverless file API using Cloudflare Workers and R2 by setting up a project, securing uploads, enabling caching, and deploying the application.
