---
title: Allow traffic from specific countries only · Cloudflare Web Application
  Firewall (WAF) docs
description: "This example custom rule blocks requests based on country code
  using the ip.src.country field, only allowing requests from two countries:
  United States and Mexico."
lastUpdated: 2025-07-14T16:11:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-specific-countries/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-specific-countries/index.md
---

This example custom rule blocks requests based on country code using the [`ip.src.country`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/ip.src.country/) field, only allowing requests from two countries: United States and Mexico.

* **Expression**: `(not ip.src.country in {"US" "MX"})`
* **Action**: *Block*

## Other resources

* [Use case: Block traffic by geographical location](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-by-geographical-location/)
* [Use case: Block traffic from specific countries](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-traffic-from-specific-countries/)
