---
title: Configure payload logging for a managed ruleset in the dashboard ·
  Cloudflare Web Application Firewall (WAF) docs
lastUpdated: 2025-10-17T11:29:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/payload-logging/configure/
  md: https://developers.cloudflare.com/waf/managed-rules/payload-logging/configure/index.md
---

Note

Only users with the [Super Administrator role](https://developers.cloudflare.com/fundamentals/manage-members/roles/) can configure payload logging and decrypt payloads in the Cloudflare dashboard. Other users can decrypt payloads if they have access to the logs and to the private key.

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com), and select your account and domain.

  2. Go to **Security** > **WAF** > **Managed rules** tab.

     ![Example Managed Rules configuration in the Managed rules tab under Security > WAF](https://developers.cloudflare.com/_astro/waf-managed-rules-tab.CJ_mD1P3_Z5LcAf.webp)

  3. To configure payload logging for a ruleset you had already deployed in the WAF, select the managed ruleset name.

  4. At the bottom of the page, select **Configure payload logging**.

  5. After reading and understanding the implications of enabling payload logging, select one of the available options:

     * **Generate key pair using your web browser**: Generates a key pair (a private and a public key) in your browser and configures payload logging with the generated public key.

     * **Use my own public key**: Enter a public key [generated by the `matched-data-cli` command-line tool](https://developers.cloudflare.com/waf/managed-rules/payload-logging/command-line/generate-key-pair/).

  6. Select **Next**.

  7. If you generated a key pair in the browser, copy the displayed private key and **store it safely**. You will use this private key later to [view the decrypted payload content](https://developers.cloudflare.com/waf/managed-rules/payload-logging/view/).

  8. Select **Done**.

  9. If you are deploying the managed ruleset where you configured payload logging, select **Deploy**. If you configured payload logging for a ruleset you had already deployed, select **Save**.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. (Optional) Filter by **Managed rules**.

  3. Search for the managed ruleset you want to configure. Look for a rule with an *Execute* action.

  4. Select the rule name (containing the name of the managed ruleset).

  5. At the bottom of the page, select **Configure payload logging**.

  6. After reading and understanding the implications of enabling payload logging, select one of the available options:

     * **Generate key pair using your web browser**: Generates a key pair (a private and a public key) in your browser and configures payload logging with the generated public key.

     * **Use my own public key**: Enter a public key [generated by the `matched-data-cli` command-line tool](https://developers.cloudflare.com/waf/managed-rules/payload-logging/command-line/generate-key-pair/).

  7. Select **Next**.

  8. If you generated a key pair in the browser, copy the displayed private key and **store it safely**. You will use this private key later to [view the decrypted payload content](https://developers.cloudflare.com/waf/managed-rules/payload-logging/view/).

  9. Select **Done**, and then select **Save**.
