---
title: Builds · Cloudflare Workers docs
description: Use Workers Builds to integrate with Git and automatically build
  and deploy your Worker when pushing a change
lastUpdated: 2025-09-25T15:56:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/ci-cd/builds/
  md: https://developers.cloudflare.com/workers/ci-cd/builds/index.md
---

The Cloudflare [Git integration](https://developers.cloudflare.com/workers/ci-cd/builds/git-integration/) lets you connect a new or existing Worker to a GitHub or GitLab repository, enabling automated builds and deployments for your Worker on push.

## Get started

### Connect a new Worker

To create a new Worker and connect it to a GitHub or GitLab repository:

1. In the Cloudflare dashboard, go to the **Workers & Pages** page.

   [Go to **Workers & Pages**](https://dash.cloudflare.com/?to=/:account/workers-and-pages)

2. Select **Create application**.

3. Select **Get started** next to **Import a repository**.

4. Under **Import a repository**, select a **Git account**.

5. Select the repository you want to import from the list. You can also use the search bar to narrow the results.

6. Configure your project and select **Save and Deploy**.

7. Preview your Worker at its provided [`workers.dev`](https://developers.cloudflare.com/workers/configuration/routing/workers-dev/) subdomain.

### Connect an existing Worker

To connect an existing Worker to a GitHub or GitLab repository:

1. In the Cloudflare dashboard, go to the **Workers & Pages** page.

   [Go to **Workers & Pages**](https://dash.cloudflare.com/?to=/:account/workers-and-pages)

2. Select the Worker you want to connect to a repository.

3. Select **Settings** and then **Builds**.

4. Select **Connect** and follow the prompts to connect the repository to your Worker and configure your [build settings](https://developers.cloudflare.com/workers/ci-cd/builds/configuration/).

5. Push a commit to your Git repository to trigger a build and deploy to your Worker.

Warning

When connecting a repository to a Workers project, the Worker name in the Cloudflare dashboard must match the `name` in the wrangler.toml file in the specified root directory, or the build will fail. This ensures that the Worker deployed from the repository is consistent with the Worker registered in the Cloudflare dashboard. For details, see [Workers name requirement](https://developers.cloudflare.com/workers/ci-cd/builds/troubleshoot/#workers-name-requirement).

## View build and preview URL

You can monitor a build's status and its build logs by navigating to **View build history** at the bottom of the **Deployments** tab of your Worker.

If the build is successful, you can view the build details by selecting **View build** in the associated new [version](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/) created under Version History. There you will also find the [preview URL](https://developers.cloudflare.com/workers/configuration/previews/) generated by the version under Version ID.

Builds, versions, deployments

If a build succeeds, it is uploaded as a version. If the build is configured to deploy (for example, with `wrangler deploy` set as the deploy command), the uploaded version will be automatically promoted to the Active Deployment.

## Disconnecting builds

To disconnect a Worker from a GitHub or GitLab repository:

1. In the Cloudflare dashboard, go to the **Workers & Pages** page.

   [Go to **Workers & Pages**](https://dash.cloudflare.com/?to=/:account/workers-and-pages)

2. Select the Worker you want to disconnect from a repository.

3. Select **Settings** and then **Builds**.

4. Select **Disconnect**.

If you want to switch to a different repository for your Worker, you must first disable builds, then reconnect to select the new repository.

To disable automatic deployments while still allowing builds to run automatically and save as [versions](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/) (without promoting them to an active deployment), update your deploy command to: `npx wrangler versions upload`.
